﻿/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_TRIB_MVA]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_TRIB_MVA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_TRIB_MVA]
GO
GO
GO

--select * from UFD_EST_PROD_TRIB_MVA (1,2,017308)
CREATE FUNCTION [dbo].[UFD_EST_PROD_TRIB_MVA](      @CD_EMP                 INT,                                                        
                                                    @CD_GRP_TRIB            INT,                                                        
                                                    @CD_PROD                INT)
                                                                        
RETURNS @RS_RETURN TABLE(CD_ID                                          INT,    
                        CD_EMP                                          INT,                                                
                        CD_CTR                                          INT,                                                    
                        CD_PROD											INT,
						CD_CLASS_FISC									INT,
						NR_NCM											varchar(50),  
                        UF                                              VARCHAR(2),
                        TP_MOV                                          int,
                        TP_TRANSA                                       int,
                        TP_LISTA										INT,
                        PERC_ICMS										MONEY,   
                        SUBS_TRIB										INT, 
						SUBS_TRIB_ANT									INT,                                               
                        VLR_PAUTA_IVA									money,
                        TP_SUBS                                         INT,
                        PERC_ICMS_EST									MONEY,                                                
                        ORIGEM_PRODUTO									INT,
                        CD_TRIB_CST										INT,
                        CD_OPER_MVA										INT,
                        CD_TBL_MVA										INT,
						CD_REGIAO_FISCAL								INT,
						VLR_PAUTA_IVA_ORIGINAL							MONEY,
						MVA_AJUSTADO									INT,
						TIPO_REGIME_EMPRESA	    						INT)
AS
BEGIN
        
        DECLARE @PERC_ALIQ_ICMS_IMPORTACAO                      VARCHAR(10)       
        DECLARE @CD_REGIAO_FISCAL                               INT        
        DECLARE @UF_FILIAL										VARCHAR(5)


        DECLARE @TBL_TRIB_PROD TABLE (  
                                CD_ID                                           INT,    
								CD_EMP                                          INT,                                                
								CD_CTR                                          INT,  
								CD_PROD											INT,
								CD_CLASS_FISC									INT,
								NR_NCM											varchar(50),                                                  
								UF                                              VARCHAR(2),
								TP_MOV                                          int,
								TP_TRANSA                                       int,
								TP_LISTA										INT,
								PERC_ICMS										MONEY,   
								SUBS_TRIB										INT,                                                
								SUBS_TRIB_ANT									INT,                                                
								VLR_PAUTA_IVA									money,
								TP_SUBS                                         INT,
								PERC_ICMS_EST									MONEY,                                                
								ORIGEM_PRODUTO									INT,
								CD_TRIB_CST										INT,
								CD_OPER_MVA										INT,
								CD_TBL_MVA										INT,
								CD_REGIAO_FISCAL								INT,
								VLR_PAUTA_IVA_ORIGINAL							MONEY,
								MVA_AJUSTADO									INT,
								TIPO_REGIME_EMPRESA								INT)				                                

        SET @PERC_ALIQ_ICMS_IMPORTACAO          = (SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(@CD_EMP, 'PERC_ALIQ_ICMS_IMPORTACAO', 0, 0))

        IF ISNUMERIC(@PERC_ALIQ_ICMS_IMPORTACAO) = 0    
                BEGIN
                        SET @PERC_ALIQ_ICMS_IMPORTACAO = 0
                END


        SET @CD_REGIAO_FISCAL = (SELECT CD_REGIAO_FISCAL FROM EST_TRIB_CONF_GRP WHERE CD_EMP = @CD_EMP AND CD_CTR = @CD_GRP_TRIB )
     
             
        ----------------------------------------------------------------------------------------------------------------
        --Buscando a UF da região fiscal
        ----------------------------------------------------------------------------------------------------------------             
        SET @UF_FILIAL =   (SELECT TOP 1 CID.UF 
							FROM PRC_FILIAL F 
									INNER JOIN GLB_CID CID ON 
											F.CD_CID = CID.CD_CID
								    INNER JOIN PRC_REGIAO_FISCAL_PRC_FILIAL RF ON 
											F.CD_EMP		= RF.CD_EMP
											AND F.CD_FILIAL = RF.CD_FILIAL
							WHERE 
									RF.CD_EMP				= @CD_EMP
									AND RF.CD_REGIAO_FISCAL = @CD_REGIAO_FISCAL)

		INSERT INTO @TBL_TRIB_PROD     
			SELECT ROW_NUMBER() OVER (ORDER BY GRP.CD_EMP) AS CD_ID,
					GRP.CD_EMP,                                
					GRP.CD_CTR,      
					ISNULL(EST_PROD.CD_PROD,0)				AS EST_PROD,
					ISNULL(EST_PROD.CD_CLASS_FISC,0)		AS CD_CLASS_FISC,
					EST_PROD.NR_NCM							AS NR_NCM,
					GRP_CPL.UF,
					GRP_CPL.TP_MOV,
					GRP_CPL.TP_TRANSA,   
					GRP_CPL.TP_LISTA, 
					GRP_CPL.PERC_ICMS    					AS PERC_ICMS,
					0										AS SUBS_TRIB,	
					0										AS SUBS_TRIB_ANT,				                                                  
					0                                       AS VLR_PAUTA_IVA,
					0                                       AS TP_SUBS,
					GRP_CPL.PERC_ICMS                       AS PERC_ICMS_EST,								
					ISNULL(EST_PROD.ORIGEM_PRODUTO,0)		AS ORIGEM_PRODUTO,
					GRP_CPL.CD_TRIB_CST						AS CD_TRIB_CST,
					GRP_CPL.CD_OPER_MVA						AS CD_OPER_MVA,
					0 										AS CD_TBL_MVA,
					@CD_REGIAO_FISCAL,
					0										AS VLR_PAUTA_IVA_ORIGINAL,
					GRP_CPL.MVA_AJUSTADO,
					GRP_CPL.TIPO_REGIME_EMPRESA 
			FROM EST_TRIB_CONF_GRP GRP
					INNER JOIN EST_TRIB_CONF_GRP_CPL GRP_CPL ON 
							GRP.CD_EMP                      = GRP_CPL.CD_EMP
							AND GRP.CD_CTR                  = GRP_CPL.CD_CTR                                        
							AND GRP_CPL.CD_OPER_MVA 		= GRP_CPL.CD_OPER_MVA                                
					LEFT JOIN EST_PROD ON 
							EST_PROD.CD_EMP                 = @CD_EMP
							AND EST_PROD.CD_PROD            = @CD_PROD
			WHERE 
					GRP.CD_EMP                      = @CD_EMP
					AND GRP.CD_CTR					= @CD_GRP_TRIB
                       
        ----------------------------------------------------------------------------------------------------------------
        --Atribuindo o percentual de icms para transacoes de entrada 
        ----------------------------------------------------------------------------------------------------------------
        UPDATE TBL_TRIB_PROD
                SET  PERC_ICMS_EST = (CASE WHEN TBL_TRIB_PROD.PERC_ICMS_EST = 0 THEN
											ISNULL((SELECT ALIQ_ICMS 
													 FROM EST_TRIB_ALIQ_ICMS 
													 WHERE UF_ORIG          = @UF_FILIAL 
														   AND UF_DEST		= @UF_FILIAL),0)
									  ELSE TBL_TRIB_PROD.PERC_ICMS_EST END),

				PERC_ICMS  = (CASE WHEN TBL_TRIB_PROD.PERC_ICMS  = 0 THEN
											ISNULL((SELECT ALIQ_ICMS 
													FROM EST_TRIB_ALIQ_ICMS 
													 WHERE UF_ORIG          = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
														   AND UF_DEST		= @UF_FILIAL),0) 
									  ELSE TBL_TRIB_PROD.PERC_ICMS END)
                     
					 --PERC_ICMS			= ISNULL((SELECT ALIQ_ICMS 
						--							FROM EST_TRIB_ALIQ_ICMS 
						--							 WHERE UF_ORIG          = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
						--								   AND UF_DEST		= @UF_FILIAL),0)                                                        
		FROM @TBL_TRIB_PROD TBL_TRIB_PROD                                                         
        WHERE 
			TBL_TRIB_PROD.TP_TRANSA = 0                                                                                                            
                        

		----------------------------------------------------------------------------------------------------------------
        --Atribuindo o percentual de icms para transacoes de saida 
        ----------------------------------------------------------------------------------------------------------------
        UPDATE TBL_TRIB_PROD
                SET  PERC_ICMS_EST = (CASE WHEN TBL_TRIB_PROD.PERC_ICMS_EST = 0 THEN
											ISNULL((SELECT ALIQ_ICMS 
													 FROM EST_TRIB_ALIQ_ICMS 
													 WHERE UF_ORIG          = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
														   AND UF_DEST		= TBL_TRIB_PROD.UF collate Latin1_General_CI_AS),0)
									  ELSE TBL_TRIB_PROD.PERC_ICMS_EST END),
                     PERC_ICMS			= ISNULL((SELECT ALIQ_ICMS 
                                                 FROM EST_TRIB_ALIQ_ICMS 
                                                 WHERE UF_ORIG      = @UF_FILIAL         
                                                       AND UF_DEST  = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS),0)                                                          
		FROM @TBL_TRIB_PROD TBL_TRIB_PROD                                                         
        WHERE 
			TBL_TRIB_PROD.TP_TRANSA = 1                         
                                                        
                
        ----------------------------------------------------------------------------------------------------------------
        --Verificando os produtos importados para fixar a aliquota padrao
        ----------------------------------------------------------------------------------------------------------------       		
		UPDATE @TBL_TRIB_PROD SET
				--PERC_ICMS_EST   = @PERC_ALIQ_ICMS_IMPORTACAO
				PERC_ICMS   = @PERC_ALIQ_ICMS_IMPORTACAO
		WHERE 
				ORIGEM_PRODUTO IN (1,2,3,8)
				AND UF <> @UF_FILIAL		
                

        ----------------------------------------------------------------------------------------------------------------
        --Atualizando dados da CST (tributacao) no produto para filiais optante pelo simples ou regime normal
        ----------------------------------------------------------------------------------------------------------------
		UPDATE TBL_TRIB_PROD SET        				
				SUBS_TRIB                               = EST_TRIB.SUBS_TRIB,
				SUBS_TRIB_ANT							= EST_TRIB.SUBS_TRIB_ANT
		FROM @TBL_TRIB_PROD TBL_TRIB_PROD				
				INNER JOIN EST_TRIB ON 
						TBL_TRIB_PROD.CD_TRIB_CST						= EST_TRIB.CD_TRIB_CST                          
						AND ISNULL(TBL_TRIB_PROD.ORIGEM_PRODUTO,0)		= EST_TRIB.ORIGEM_PRODUTO                               
		WHERE 
				EST_TRIB.TIPO_REGIME_EMPRESA = 0
                                
                                                
        ----------------------------------------------------------------------------------------------------------------
        --Atualizando o MVA, Pauta, PMC e carga tributaria para os produtos ST cujo grupo possua vinculo com a tabela de MVA
        ----------------------------------------------------------------------------------------------------------------
        IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT=1) AND CD_TBL_MVA = 0)                          
                BEGIN                                                        
					UPDATE TBL_TRIB_PROD SET 
							VLR_PAUTA_IVA   = MVA_CPL.ALIQ_MVA,
							TP_SUBS         = MVA_CPL.TP_SUBS,
							CD_TBL_MVA      = MVA_CPL.CD_TBL_MVA,
							VLR_PAUTA_IVA_ORIGINAL=MVA_CPL.ALIQ_MVA
					FROM @TBL_TRIB_PROD TBL_TRIB_PROD
							INNER JOIN EST_TRIB_ALIQ_MVA_EST_TRIB_CONF_GRP GRP_MVA ON
									TBL_TRIB_PROD.CD_EMP                            = GRP_MVA.CD_EMP
									AND TBL_TRIB_PROD.CD_CTR                        = GRP_MVA.CD_CTR
							INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
									MVA.CD_EMP                                      = GRP_MVA.CD_EMP
									AND MVA.CD_TBL_MVA                              = GRP_MVA.CD_TBL_MVA   									
							INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
									GRP_MVA.CD_EMP                                  = MVA_CPL.CD_EMP
									AND GRP_MVA.CD_TBL_MVA                          = MVA_CPL.CD_TBL_MVA
							INNER JOIN EST_TRIB_OPER_MVA ON 
									MVA_CPL.CD_OPER_MVA                             = EST_TRIB_OPER_MVA.CD_OPER_MVA                         
									AND EST_TRIB_OPER_MVA.TP_OPER					= 1
									AND EST_TRIB_OPER_MVA.ALIQ_OPER					= TBL_TRIB_PROD.PERC_ICMS 
					WHERE                           
							MVA_CPL.UF_DEST                                         = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
							AND (TBL_TRIB_PROD.SUBS_TRIB      = 1
							OR TBL_TRIB_PROD.SUBS_TRIB_ANT=1)
							AND TBL_TRIB_PROD.CD_OPER_MVA							= 0		
							AND TBL_TRIB_PROD.CD_TBL_MVA							= 0	
							AND MVA.TP_TRANSA										IN (TBL_TRIB_PROD.TP_TRANSA, 2)
				END

        -------------------------------------------------------------------------------------------------------------------------------------------------
        --Atualizando o MVA, Pauta, PMC e carga tributaria para os produtos ST cujo grupo possua vinculo com a tabela de MVA e operacao MVA especifico
        -------------------------------------------------------------------------------------------------------------------------------------------------
        IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT = 1) AND CD_TBL_MVA = 0)  
                BEGIN																	
					UPDATE TBL_TRIB_PROD SET 
							VLR_PAUTA_IVA   = MVA_CPL.ALIQ_MVA,
							TP_SUBS         = MVA_CPL.TP_SUBS,
							CD_TBL_MVA      = MVA_CPL.CD_TBL_MVA,
							VLR_PAUTA_IVA_ORIGINAL=MVA_CPL.ALIQ_MVA
					FROM @TBL_TRIB_PROD TBL_TRIB_PROD
							INNER JOIN EST_TRIB_ALIQ_MVA_EST_TRIB_CONF_GRP GRP_MVA ON
									TBL_TRIB_PROD.CD_EMP                            = GRP_MVA.CD_EMP
									AND TBL_TRIB_PROD.CD_CTR                        = GRP_MVA.CD_CTR
							INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
									MVA.CD_EMP                                      = GRP_MVA.CD_EMP
									AND MVA.CD_TBL_MVA                              = GRP_MVA.CD_TBL_MVA                            
							INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
									GRP_MVA.CD_EMP                                  = MVA_CPL.CD_EMP
									AND GRP_MVA.CD_TBL_MVA                          = MVA_CPL.CD_TBL_MVA
									AND TBL_TRIB_PROD.CD_OPER_MVA                   = MVA_CPL.CD_OPER_MVA
									AND MVA_CPL.UF_DEST								= TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
					WHERE                           
							(TBL_TRIB_PROD.SUBS_TRIB      = 1
							OR TBL_TRIB_PROD.SUBS_TRIB_ANT=1)
							AND TBL_TRIB_PROD.CD_OPER_MVA						<> 0
							AND TBL_TRIB_PROD.CD_TBL_MVA						= 0			
							AND MVA.TP_TRANSA										IN (TBL_TRIB_PROD.TP_TRANSA, 2)							
                END     
               

		----------------------------------------------------------------------------------------------------------------
        --Atualizando o MVA, Pauta, PMC e carga tributaria para os produtos ST cujo grupo nao possua vinculo com a tabela de MVA
        ----------------------------------------------------------------------------------------------------------------
       IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT=1) AND CD_TBL_MVA = 0)                            
                BEGIN                                                        
					UPDATE TBL_TRIB_PROD SET 
							VLR_PAUTA_IVA   = MVA_CPL.ALIQ_MVA,
							TP_SUBS         = MVA_CPL.TP_SUBS,
							CD_TBL_MVA      = MVA_CPL.CD_TBL_MVA,
							VLR_PAUTA_IVA_ORIGINAL=MVA_CPL.ALIQ_MVA
					FROM @TBL_TRIB_PROD TBL_TRIB_PROD
                            INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                                    MVA.CD_EMP                                      = TBL_TRIB_PROD.CD_EMP
                                    AND MVA.TP_LISTA                                = TBL_TRIB_PROD.TP_LISTA                                                        
                                    AND MVA.CD_CLASS_FISC                           = TBL_TRIB_PROD.CD_CLASS_FISC     
									AND MVA.CD_REGIAO_FISCAL						= TBL_TRIB_PROD.CD_REGIAO_FISCAL                                            
                            INNER JOIN EST_TRIB_ALIQ_MVA_NCM MVA_NCM ON     
                                    MVA.CD_EMP                                      = MVA_NCM.CD_EMP
                                    AND MVA.CD_TBL_MVA                              = MVA_NCM.CD_TBL_MVA
                                    AND MVA_NCM.NR_NCM                              = TBL_TRIB_PROD.NR_NCM  collate Latin1_General_CI_AS                        
							INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
									MVA_CPL.CD_EMP                                  = MVA.CD_EMP
                                    AND MVA_CPL.CD_TBL_MVA                          = MVA.CD_TBL_MVA									
							INNER JOIN EST_TRIB_OPER_MVA ON 
									MVA_CPL.CD_OPER_MVA                             = EST_TRIB_OPER_MVA.CD_OPER_MVA                         
									AND EST_TRIB_OPER_MVA.TP_OPER					= 1
									AND EST_TRIB_OPER_MVA.ALIQ_OPER					= TBL_TRIB_PROD.PERC_ICMS 
					WHERE                           
							MVA_CPL.UF_DEST                                         = TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
							AND (TBL_TRIB_PROD.SUBS_TRIB      = 1
							OR SUBS_TRIB_ANT=1)
							AND TBL_TRIB_PROD.CD_OPER_MVA							= 0
							AND TBL_TRIB_PROD.CD_TBL_MVA							= 0
							AND MVA.TP_TRANSA										IN (TBL_TRIB_PROD.TP_TRANSA, 2)
				END

        -------------------------------------------------------------------------------------------------------------------------------------------------
        --Atualizando o MVA, Pauta, PMC e carga tributaria para os produtos ST cujo grupo possua vinculo com a tabela de MVA e operacao MVA especifico
        -------------------------------------------------------------------------------------------------------------------------------------------------
        IF EXISTS(SELECT CD_EMP FROM @TBL_TRIB_PROD WHERE (SUBS_TRIB = 1 OR SUBS_TRIB_ANT = 1) AND CD_TBL_MVA = 0)                          
                BEGIN																	
					UPDATE TBL_TRIB_PROD SET 
							VLR_PAUTA_IVA   = MVA_CPL.ALIQ_MVA,
							TP_SUBS         = MVA_CPL.TP_SUBS,
							CD_TBL_MVA      = MVA_CPL.CD_TBL_MVA,
							VLR_PAUTA_IVA_ORIGINAL=MVA_CPL.ALIQ_MVA
					FROM @TBL_TRIB_PROD TBL_TRIB_PROD
                            INNER JOIN EST_TRIB_ALIQ_MVA MVA ON 
                                    MVA.CD_EMP                                      = TBL_TRIB_PROD.CD_EMP
                                    AND MVA.TP_LISTA                                = TBL_TRIB_PROD.TP_LISTA                                                        
                                    AND MVA.CD_CLASS_FISC                           = TBL_TRIB_PROD.CD_CLASS_FISC   
									AND MVA.CD_REGIAO_FISCAL						= TBL_TRIB_PROD.CD_REGIAO_FISCAL                                            
                            INNER JOIN EST_TRIB_ALIQ_MVA_NCM MVA_NCM ON     
                                    MVA.CD_EMP                                      = MVA_NCM.CD_EMP
                                    AND MVA.CD_TBL_MVA                              = MVA_NCM.CD_TBL_MVA
                                    AND MVA_NCM.NR_NCM                              = TBL_TRIB_PROD.NR_NCM   collate Latin1_General_CI_AS                       
							INNER JOIN EST_TRIB_ALIQ_MVA_CPL MVA_CPL ON 
									MVA_CPL.CD_EMP                                  = MVA.CD_EMP
                                    AND MVA_CPL.CD_TBL_MVA                          = MVA.CD_TBL_MVA                         
									AND TBL_TRIB_PROD.CD_OPER_MVA                   = MVA_CPL.CD_OPER_MVA
									AND MVA_CPL.UF_DEST								= TBL_TRIB_PROD.UF collate Latin1_General_CI_AS
					WHERE                           
							(TBL_TRIB_PROD.SUBS_TRIB      = 1
							OR TBL_TRIB_PROD.SUBS_TRIB_ANT=1)
							AND TBL_TRIB_PROD.CD_OPER_MVA						<> 0
							AND TBL_TRIB_PROD.CD_TBL_MVA						= 0		
							AND MVA.TP_TRANSA										IN (TBL_TRIB_PROD.TP_TRANSA, 2)
                END 

--Ajuste de IVA	caso esteja marcado no grupo de tributacao	     
        UPDATE 
			TBL_TRIB_PROD 
		SET
			VLR_PAUTA_IVA = (ROUND(((1+(VLR_PAUTA_IVA/100.00))*((1-(PERC_ICMS/100.00))/(1-(PERC_ICMS_EST/100.00))))-1,4))*100
        FROM 
			@TBL_TRIB_PROD TBL_TRIB_PROD
        WHERE                           
			TBL_TRIB_PROD.PERC_ICMS < TBL_TRIB_PROD.PERC_ICMS_EST
			AND TBL_TRIB_PROD.MVA_AJUSTADO=1           
			                                  
        ----------------------------------------------------------------------------------------------------------------
        --Retornando tributacoes
        ----------------------------------------------------------------------------------------------------------------
        INSERT INTO @RS_RETURN
                SELECT * FROM @TBL_TRIB_PROD
        
        RETURN 
END


